<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-04-23 00:01
 */
interface PremiumautomaticDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Premiumautomatic 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param premiumautomatic primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Premiumautomatic premiumautomatic
 	 */
	public function insert($premiumautomatic);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Premiumautomatic premiumautomatic
 	 */
	public function update($premiumautomatic);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTotalinstallment($value);

	public function queryByPresenterDir($value);

	public function queryByPresenterPer($value);

	public function queryByDate($value);

	public function queryByRemainAmount($value);

	public function queryByInstallmentNos($value);

	public function queryByInstallmentMonths($value);

	public function queryByInstallmentDays($value);

	public function queryByClientId($value);

	public function queryByUserid($value);


	public function deleteByTotalinstallment($value);

	public function deleteByPresenterDir($value);

	public function deleteByPresenterPer($value);

	public function deleteByDate($value);

	public function deleteByRemainAmount($value);

	public function deleteByInstallmentNos($value);

	public function deleteByInstallmentMonths($value);

	public function deleteByInstallmentDays($value);

	public function deleteByClientId($value);

	public function deleteByUserid($value);


}
?>